#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//You are going to LondonMod01.fsh   by   Retard_Gaming  
//https://www.shadertoy.com/view/DsfGWH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0666 //0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// simple 3d function
vec2 c(float x, float y, float z) {
    float v = 0.-y; // replace 0 with distance if you want to move camera foward and back
    
    if(v > 0.) {
        return vec2(1./0.);
    }
    return -vec2(x,z)/y;
}

// convert given point to uv coordinates where a,b,c,d are (0,0),(1,0),(1,1),(0,1) respectively
// this only works if a.x=d.x and b.x=c.x
vec2 uvTetragon(vec2 a, vec2 b, vec2 c, vec2 d, vec2 p) {
    float ab = (p.x-a.x)/(b.x-a.x);
    float dc = (p.x-d.x)/(c.x-d.x);
    float ad = (p.y-a.y)/(d.y-a.y);
    float bc = (p.y-b.y)/(c.y-b.y);
    
    float u = (1.-ad)*ab + dc*ad;
    float v = (1.-ab)*ad + bc*ab;
    float h = (ad-bc)*(ab-dc)-1.;
    
    u = ab;
    
    float ab2 = (b.y - a.y) * u + a.y;
    float cd2 = (c.y - d.y) * u + d.y;
    
    
    v = (p.y - ab2)/(cd2-ab2);
    
    vec2 uv = vec2(u,v)/h;
    
    return uv;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;
    
    //figure eight pattern with camera
    vec2 offset = vec2(cos(iTime), sin(iTime)*cos(iTime))/(5.);

    vec3 col;
    float time = mod(iTime, 1.) * 3. - 1.;
    uv *= 5. + sin(iTime);
    uv -= 2. + sin(iTime) / 2. + offset/2.;
    
    if(uv.x < 1. && uv.x > 0. && uv.y < 1. && uv.y > 0.) {
        col += texture2D(texture0, uv).rgb;
    }
    
    uv += 2. + sin(iTime) / 2. + offset/2.;
    uv /= 5. + sin(iTime);
    
    for(float y = -1.; y < 8.; y+=1.) {
        for(float x = -1.; x < 2.; x+=2.) {
            if(col.r == 0. && col.g == 0. && col.b == 0.) {
                vec2 p1 = c(x-offset.x, y - time, -1.-offset.y);
                vec2 p2 = c(x-offset.x, y - time + 1., -1.-offset.y);
                vec2 p3 = c(x-offset.x, y - time + 1., 1.-offset.y);
                vec2 p4 = c(x-offset.x, y - time, 1.-offset.y);
                vec2 uv1 = uvTetragon(p1, p2, p3, p4, uv*2.-1.);
                if(uv1.x < 0. && uv1.x > -1. && uv1.y < 0. && uv1.y > -1.) {
                    col += texture2D(texture0, uv1).rgb;
                }
                p1 = c(x-offset.y, y - time, -1.-offset.x);
                p2 = c(x-offset.y, y - time + 1., -1.-offset.x);
                p3 = c(x-offset.y, y - time + 1., 1.-offset.x);
                p4 = c(x-offset.y, y - time, 1.-offset.x);
                vec2 uv2 = uvTetragon(p1, p2, p3, p4, vec2(uv.y, uv.x)*2.-1.);
                if(uv2.x < 0. && uv2.x > -1. && uv2.y < 0. && uv2.y > -1.) {
                    col += texture2D(texture0, vec2(uv2.y, -uv2.x)).rgb;
                }
            }
          
        }
    }

    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

